module reg_file(clk, A_addr, B_addr, C_addr, A_data, B_data, C_data,
                W_addr, W_data, W_write);

  input clk;
  input[3:0] A_addr, B_addr, C_addr, W_addr;
  output[15:0] A_data, B_data, C_data;
  input[15:0] W_data;
  input W_write;

  reg[15:0] r[15:0];
  
  always @(negedge clk)
    begin
      if(W_write)
        begin
          r[W_addr] <= W_data;

          // diagnostic out: writes to R15 go to console
//          if(W_addr == 15)
//            $display("Write: %4h", W_data);
          $display("* R%d = %4h", W_addr, W_data);

        end
    end

  assign A_data = r[A_addr];
  assign B_data = r[B_addr];
  assign C_data = r[C_addr];

endmodule
