module preg16(clk, reset, in, out, stall, bubble, nop);
  input clk;
  input reset;

  input[15:0] in;
  input stall;
  input bubble;
  input[15:0] nop; // value inserted by bubble and loaded at reset
  output[15:0] out;

  reg[15:0] r;

  assign out = r;

  always @(posedge clk or reset)
    begin
      if(reset)
        r <= nop;
      else
        begin
          if(stall)
            r <= r;
          else if(bubble)
            r <= nop;
          else
            r <= in;
        end
    end

endmodule