module preg1(clk, reset, in, out, stall, bubble, nop);
  input clk;
  input reset;
  
  input in;
  input stall;
  input bubble;
  input nop; // value inserted by bubble and loaded at reset
  output out;

  reg r;

  assign out = r;
  
  always @(posedge clk or reset)
    begin
      if(reset)
        r <= nop;
      else
        begin
          if(stall)
            r <= r;
          else if(bubble)
            r <= nop;
          else
            r <= in;
        end
    end

endmodule