module pipe4(in_insn, in_Q, RF_W_addr, RF_W_data, RF_W_write);

  input[15:0] in_insn, in_Q;

  output[3:0] RF_W_addr;
  output[15:0] RF_W_data;
  output reg RF_W_write;

  assign RF_W_addr = in_insn[11:8]; // rC -- always destination
  assign RF_W_data = in_Q;

  wire[3:0] op;
  assign op = in_insn[15:12];

  always @(op)
    begin
      RF_W_write = 0;
      case(op)
        0: RF_W_write = 1; // LD
        1: RF_W_write = 0; // ST
        2: RF_W_write = 1; // ADD
        3: RF_W_write = 1; // LDC
        4: RF_W_write = 1; // SUB
        5: RF_W_write = 0; // JMPZ
        6: RF_W_write = 0; // JMPN
        7: RF_W_write = 0; // JMP
        8: RF_W_write = 1; // MUL
        9: RF_W_write = 1; // DIV
        10: RF_W_write = 1; // MOD
        13: RF_W_write = 1; // LDR
        14: RF_W_write = 0; // STR
        11: $finish; // END
        default: RF_W_write = 0;
      endcase
    end

endmodule
