module pipe3(in_insn, in_Q, in_C, out_insn, out_Q,
             DM_addr, DM_data, DM_wdata, DM_write);
  
  input[15:0] in_insn, in_Q, in_C;
  output[15:0] out_insn;
  output reg[15:0] out_Q;

  output reg[15:0] DM_addr, DM_wdata;
  input[15:0] DM_data;
  output reg DM_write;

  assign out_insn = in_insn;

  wire[3:0] op;
  assign op = in_insn[15:12];

  // stage 3: data memory access (loads/stores)
  //
  //   if we have a load/store, Q will be addr and C will be value (in
  //   case of store); we output value on Q (in case of
  //   load). Otherwise, pass through instruction and Q.

  // we imply muxes here
  always @(op or in_Q or in_C or DM_data)
    begin
      if(op == 0 || op == 13) // LD, LDR
        begin
          DM_addr = in_Q;
          out_Q = DM_data;
          DM_wdata = 0;
          DM_write = 0;
        end
      else if(op == 1 || op == 14) // ST, STR
        begin
          DM_addr = in_Q;
          out_Q = DM_data;
          DM_wdata = in_C;
          DM_write = 1;
          $display("Write: addr %4h, data %4h", DM_addr, DM_wdata);
        end
      else // all others: no DM access (load-store architecture!)
        begin
          DM_addr = 0;
          out_Q = in_Q;
          DM_wdata = 0;
          DM_write = 0;
        end
    end

  
endmodule
