module pipe1(in_insn, out_insn, out_A, out_B, out_C, out_K, out_Pred,
             RF_A_addr, RF_B_addr, RF_A_data, RF_B_data,
             RF_C_addr, RF_C_data,
             BranchPred, BranchPredOff);

  input[15:0] in_insn;
  output[15:0] out_insn, out_A, out_B, out_C, out_K;
  output out_Pred;

  output[3:0] RF_A_addr, RF_B_addr, RF_C_addr;
  input[15:0] RF_A_data, RF_B_data, RF_C_data;
  wire intBranch;
  

  input BranchPred;
  output[15:0] BranchPredOff;

  // stage 1: RegRead
assign intBranch = BranchPred;
  assign out_insn = in_insn;

  assign out_A = RF_A_data;
  assign out_B = RF_B_data;
  assign out_C = RF_C_data;

  assign RF_A_addr = in_insn[7:4];
  assign RF_B_addr = in_insn[3:0];
  assign RF_C_addr = in_insn[11:8];

  // zero-extended 8-bit immediate
  assign out_K = {8'h00, in_insn[7:0]};

  // Branch offset, if branch predicted: sign-extended 8-bit immediate
  assign BranchPredOff = {in_insn[7], in_insn[7], in_insn[7], in_insn[7],
                          in_insn[7], in_insn[7], in_insn[7], in_insn[7],
                          in_insn[7:0]};

  // comes from branch predictor instance under toplevel cpu module
  assign out_Pred = BranchPred;
  
endmodule
             
