`timescale 1ns / 1ps

module inst_mem(clka, addra, douta);
  input clka;
  input [15:0] addra;
  output reg[15:0] douta;

  always @(addra)
    begin
      case(addra)
        0: douta <= 16'h3064;
        1: douta <= 16'h3101;
        2: douta <= 16'h3202;
        3: douta <= 16'h3301;
        4: douta <= 16'hE320;
        5: douta <= 16'h2221;
        6: douta <= 16'h4402;
        7: douta <= 16'h6402;
        8: douta <= 16'h70FC;
        9: douta <= 16'h3202;
        10: douta <= 16'h4702;
        11: douta <= 16'h670F;
        12: douta <= 16'hF000;
        13: douta <= 16'hF000;
        14: douta <= 16'hF000;
        15: douta <= 16'hF000;
        16: douta <= 16'h3402;
        17: douta <= 16'h3600;
        18: douta <= 16'h8542;
        19: douta <= 16'h4705;
        20: douta <= 16'h6704;
        21: douta <= 16'hE650;
        22: douta <= 16'h2441;
        23: douta <= 16'h70FB;
        24: douta <= 16'h2221;
        25: douta <= 16'h70F1;
        26: douta <= 16'h3202;
        27: douta <= 16'h4702;
        28: douta <= 16'h6707;
        29: douta <= 16'hD420;
        30: douta <= 16'h2221;
        31: douta <= 16'h54FC;
        32: douta <= 16'h4F21;
        33: douta <= 16'hF000;
        34: douta <= 16'h70F9;
        35: douta <= 16'hB000;
        default: douta <= 16'h0000;
      endcase
    end

endmodule
