`timescale 1ns / 1ps
//////////////////////////////////////////////////////////////////////////////////
// Company: University of Notre Dame
// 
// Create Date:    00:18:55 03/28/2007 
// Module Name:    alu 
// Project Name: CSE30321
// Target Devices: xc3s100e-5vq100
// Description: Implementation of the Six-instruction processor from
// Frank Vahid's Digital Design, Ch. 8 
//
// Additional Comments: 
//
//////////////////////////////////////////////////////////////////////////////////
module alu(A, B, D, op, Z, LT);
	input[15:0] A, B;
  input[2:0] op;
	output reg[15:0] D;
	output reg Z, LT;
	
	always @(A, B, op) begin
		//add
		if(op == 3'b001) D = A + B;

		//sub
		else if(op == 3'b010) D = A - B;

		//pass A
		else if(op == 3'b000) D = A;

    // mul (1-cycle)
    else if(op == 3'b100) D = A * B;

    // div (1-cycle, MAGIC)
    else if(op == 3'b101) D = A / B;

    // mod (1-cycle, MAGIC)
    else if(op == 3'b110) D = A % B;
		
		//set zero_flag
		if(A == 0) Z = 1;
		else Z = 0;
		
		//set neg flag if A < 0
		if(A[15] == 1) LT = 1;
		else LT = 0;
	end
endmodule
