/**
 * \file mon.h
 * \author cfallin
 * \date 2008-01-23
 *
 * Monitor (command language).
 */

#ifndef _JAM3DI_MON_H_
#define _JAM3DI_MON_H_

#include "mem.h"
#include "cpu.h"

#include <string>
using std::string;

class Monitor
{
protected:
  CPU *m_cpu;
  Memory *m_mem;
  word m_breakpoint;

public:
  Monitor(CPU *cpu, Memory *mem) : m_cpu(cpu), m_mem(mem) {}
  ~Monitor() {}

  string doCommand(string cmd);

private:
  string doHelp(string args);
  // memory load/save
  string doLoad(string args);
  string doSave(string args);
  // memory access
  string doPeek(string args);
  // register dump
  string doReg(string args);
  // CPU control
  string doReset(string args);
  string doStep(string args);
  string doRun(string args);
  string doBreak(string args);
  string doCount(string args);
};

#endif
