/**
 * \file mem.h
 * \author cfallin
 * \date 2008-01-23
 *
 * Memory space for emulator.
 */

#ifndef _JAM3DI_MEM_H_
#define _JAM3DI_MEM_H_

#include <string>
#include <vector>


typedef int word;

class Memory
{
friend class CPU;
public:
  static const int Width = 16;
  static const int Words = 32768;

protected:
  word *m_words;

public:
  Memory();
  ~Memory();

  bool Load(std::string filename);
  bool Save(std::string filename);

  word Read(int address);
  void Write(int address, word data);
};

#endif
