/**
 * \file mem.cpp
 * \author cfallin
 * \date 2008-01-23
 *
 * Memory space for emulator.
 */

#include "mem.h"
#include <fstream>
#include <iostream>
#include <iomanip>
#include <exception>

using namespace std;

Memory::Memory()
{
  m_words = new word[Memory::Words];
  for(int i = 0; i < Memory::Words; i++)
    m_words[i] = 0;
}

Memory::~Memory()
{
  delete [] m_words;
  m_words = 0;
}

static int hex_parse(char c)
{
  if(c >= '0' && c <= '9')
    return c - '0';
  if(c >= 'A' && c <= 'F')
    return c - 'A' + 10;
  if(c >= 'a' && c <= 'f')
    return c - 'a' + 10;
  return 0;
}

static char hex_char(int d)
{
  if(d < 10)
    return d + '0';
  if(d < 16)
    return d - 10 + 'A';
  return '?';
}

bool Memory::Load(string filename)
{
  ifstream in;

  try
  {
    in.open(filename.c_str());
    if(in.fail())
      return false;
  }
  catch(exception e)
  {
    return false;
  }


  for(int i = 0; i < Memory::Words; i++)
  {
    string s;
    in >> s;

    word w = 0;
    for(int j = 0; j < s.length(); j++)
    {
      w <<= 4;
      w += hex_parse(s[j]);
    }

    m_words[i] = w;
  }

  in.close();
  return true;
}

bool Memory::Save(string filename)
{
  ofstream out;

  try
  {
    out.open(filename.c_str());
    if(out.fail())
      return false;
  }
  catch(exception e)
  {
    return false;
  }

  for(int i = 0; i < Memory::Words; i++)
  {
    word w = m_words[i];
    int digits = (Memory::Width+1)/4;

    for(int j = digits - 1; j >= 0; j--)
      out << hex_char((w >> (j*4)) & 0xF);

    out << endl;
  }

  out.close();
  return true;
}

word Memory::Read(int address)
{
  if(address < 0) address += Memory::Words;
  return m_words[address & (Memory::Words - 1)];
}

void Memory::Write(int address, word data)
{
  if(address < 0) address += Memory::Words;
  m_words[address & (Memory::Words - 1)] = data;

  if(address == 0x6000)
    cout << "Write6000: " << setw(4) << setfill('0') << hex << data << endl;
}
