/**
 * \file main.cpp
 * \author cfallin
 * \date 2008-01-23
 *
 * Main driver.
 */

#include "mem.h"
#include "cpu.h"
#include "mon.h"

#include <iostream>
#include <fstream>
#include <string>

using namespace std;

void doCommands(istream &in, ostream &out, bool isInteractive)
{
  // Construct the machine
  Memory mem;
  CPU cpu(&mem);
  Monitor mon(&cpu, &mem);

 // main loop
  while(1)
  {
    char buf[1024];

    if(isInteractive)
    {
      out << "jami> ";
      out.flush();
    }

    in.getline(buf, 1024);
    if(in.eof() || in.fail()) break;

    string cmd(buf);
    string ret;

    ret = mon.doCommand(cmd);

    out << ret << endl;
  }

  if(isInteractive)
    cout << endl << "jami done." << endl;
}

int main(int argc, char **argv)
{
  if(argc > 1)
  {
    // command script provided - run it
    ifstream in;
    in.open(argv[1]);
    if(in.fail())
    {
      cerr << "Could not open script file " << argv[1] << endl;
      return 1;
    }

    doCommands(in, cout, false);
  }
  else
  {
    // no script - provide an interactive command line
    doCommands(cin, cout, true);
  }
 
  return 0;
}
