/**
 * \file cpu.h
 * \author cfallin
 * \date 2008-01-23
 *
 * Emulator CPU core.
 */
#ifndef _JAM3DI_CPU_H_
#define _JAM3DI_CPU_H_

#include "mem.h"
#include <map>
#include <string>
#include <iomanip>
#include <fstream>

using namespace std;

class Monitor;

class CPU
{
  friend class Monitor; // allow access to registers

public:
  static const int NReg = 16;

protected:
  word m_regs[NReg];
  word m_pc, m_i, m_l;

  Memory *m_mem;

  int m_count_insn, m_count_jmp;

public:
  CPU(Memory *mem) : m_mem(mem) { Reset(); }
  ~CPU() {}

  void Reset();
  bool Step(int n);
  bool Step();
};

#endif
