#!/usr/bin/env python

import sys

# --- readfile(): reads a file into a list of a list of symbols
def readfile(file):
    # read lines
    f = open(file)
    lines = f.readlines()
    f.close()

    # process lines
    symlist = []
    for l in lines:
        # process .include lines
        if(l.startswith('.include')):
            symlist += readfile(l[8:].strip())
            continue
        # strip comments, whitespace
        cmt = l.find('//')
        if(cmt != -1):
            l = l[0:cmt]
        l = l.strip()

        if(l == ''): continue

        symlist.append( (l, l.split()) )

    return symlist

# --- assemble(): turns a list of a list of symbols into a list of words
def assemble(symlist, lst):
    
    eqs = {}
    words = [] # output: memory words (starting from 0)
    fixup = [] # list of [address, label]: ORs label value into address
    labels = {} # label-name -> address

    def evalsyms(syms, addr):
        val = 0
        for s in syms:
            if(eqs.has_key(s)):
                val = val | eqs[s]
            elif(labels.has_key(s)):
                val = val | labels[s]
            elif(s[0].isdigit()):
                if(s.startswith('0x') or s.startswith('0X')):
                    val = val | int(s[2:], 16)
                else:
                    val = val | int(s)
            else:
                # unknown label: record fixup record
                fixup.append([addr, s])
        return val

    # process assembly input, one line at a time
    for syms in symlist:
        line, syms = syms
        
        # if line starts with a label, record location and remove from line
        if(syms[0].endswith(':')):
            labels[syms[0][:-1]] = len(words)
            syms = syms[1:]
            if(len(syms) == 0): continue

        # if line starts with .eq, record that and move onto next line
        if(syms[0] == '.eq'):
            if(len(syms) < 3): continue
            eq = syms[1]
            if(syms[2].startswith('0x') or syms[2].startswith('0X')):
                val = int(syms[2][2:], 16)
            else:
                val = int(syms[2])
            eqs[eq] = val
            continue

        # else, this is a word to output
        val = evalsyms(syms, len(words))
        words.append(val)

        lst.write('%04x: %04x   %s\n' % (len(words)-1, val, line))

    # now process fixups
    for f in fixup:
        addr = f[0]
        label = f[1]
        if(not labels.has_key(label)):
            print "Unknown label", label
            sys.exit(1)
        words[addr] = words[addr] | labels[label]

    # done
    return words

# main driver
def main(argv):
    if(len(argv) < 2):
        print "Usage: genasm.py <input> <output> <fillsize>"
        sys.exit(1)

    infile = argv[0]
    outfile = argv[1]

    fillsize = '0'
    if(len(argv) > 2):
        fillsize = argv[2]

    if(fillsize.startswith('0x')):
        fillsize = int(fillsize[2:], 16)
    else:
        fillsize = int(fillsize)

    if(fillsize != 0):
        print "Filling output to 0x%04x bytes" % fillsize

    lst = open(outfile + '.lst', 'w')

    symlist = readfile(infile)
    words = assemble(symlist, lst)

    o = open(outfile, 'w')
    for word in words:
        o.write('%04x\n' % word)
    if(fillsize != 0):
        for i in xrange(fillsize - len(words)):
            o.write('0000\n')
    o.close()

main(sys.argv[1:])
