.include defs.inc

        jmp reset_handler
        jmp trap_handler
        jmp uflow_handler
        jmp oflow_handler

reset_handler:
        trap
        ldim ra0
        4
        jmp done
trap_handler:   
        
        ldpc ra15
        addi ra15 3
        jmp test_stack
        skz ra0
        jmp bad01

        ldpc ra15
        addi ra15 3
        jmp test_arith
        skz ra0
        jmp bad02

        ldpc ra15
        addi ra15 3
        jmp test_ldst
        skz ra0
        jmp bad03

        ldim ra0
        0
        jmp done
bad01:  ldim ra0
        1
        jmp done
bad02:  ldim ra0
        2
        jmp done
bad03:  ldim ra0
        3
        jmp done
done:   ldim ra1
        0x6000
        st ra0 rb1
here:   finish
        jmp here

test_stack:
        mov ra14 rb15 // save ret addr (overwritten by traps)
        
        ldim ra0
        0x80
        il ra0
	addi ra0 0
	addi ra0 0
	addi ra0 0
	addi ra0 0

        il ra0
        mov ra1 rb0
        il ra0

        ldim ra2
        0x80
        sub ra1 rb2
        skz ra1
        jmp stackbad

        ldim inc ra0
        1
        ldim inc ra0
        2
        ldim inc ra0
        3
        add dec ra14 rb15
        add dec ra14 rb15
        ldim ra8
        6
        sub ra8 rb0
        skz ra8
        jmp stackbad

        ldim inc ra0
        4
        add rel ra15 rb14
        ldim ra8
        10
        sub ra8 rb1
        skz ra8
        jmp stackbad


        // force overflow
        ldim inc ra0
        0
        ldim inc ra0
        0
        ldim inc ra0
        0
        ldim inc ra0
        0
        ldim inc ra0
        0
        ldim inc ra0
        0
        ldim inc ra0
        0
        ldim inc ra0
        0
        jmp stackbad
oflow_handler:

        // force underflow
        ldim ra0
        0x90
        il ra0
	addi ra0 0
	addi ra0 0
	addi ra0 0
	addi ra0 0
        ldim rel ra15
        0
        jmp stackbad
uflow_handler:

        ldim ra0
        0
        jr ra14         // OK

stackbad:
        ldim ra0
        1
        jr ra14

test_arith:
        ldpc ra0
        ldim ra1
        test_arith
        sub ra0 rb1
        skz ra0
        jmp arithbad

        ldim ra0
        0xffff
        skn ra0
        jmp arithbad

        ldim ra0
        1
        ldim ra1
        2
        add ra0 rb1
        ldim ra2
        3
        sub ra2 rb0
        skz ra2
        jmp arithbad

        ldim ra0
        42
        addi ra0 2      // R0 = 44 = 0x2c
        ldim ra1
        4
        and ra1 rb0     // R1 = 4
        ldim ra0
        12
        or ra1 rb0      // R1 = 12

        sll ra1
        srl ra1
        sll ra1         // R1 = 24
        ldim ra0
        8
        xor ra1 ra0     // R1 = 16

        not ra1
        not ra1
        high ra1        // R1 = 0x7010

        ldim ra8
        0x92
        il ra8

        mova rel ra8 rb15 // R8 = R1 = 0x7010
        ori ra8 1       // R8 = 0x7011
        movb rel ra15 rb8 // R1 = 0x7011

        subi ra1 1
        srl ra1
        srl ra1
        srl ra1
        srl ra1
        subi ra1 1
        ldim ra0
        0x700
        sub ra0 rb1

        ldim ra0
        0
        jr ra15         // OK
        
arithbad:
        ldim ra0
        1
        jr ra15

test_ldst:
        ldim ra0
        0x4242

        ldim ra1
        test_ldst
        addi ra1 1
        ld ra2 rb1

        sub ra2 rb0
        skz ra2
        jmp ldstbad

        ldim ra1
        L
        st ra0 rb1
        addi ra0 0
        addi ra0 0
        addi ra0 0
        addi ra0 0
        addi ra0 0      // 5 NOPs to ensure pipe is flushed
        
        ldim ra3
L:      0x2424          // modified above to 0x4242

        ldim ra4
        0x4242

        sub ra3 rb4
        skz ra3
        jmp ldstbad

        ldim ra0
        0
        jr ra15

ldstbad:
        ldim ra0
        1
        jr ra15
